define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('PatientFHIRService', function ($q, BaseFHIRService, localResourceDirectoryService) {
        return angular.extend({}, angular.copy(BaseFHIRService), {
            type: 'Patient',

            getPatientContext: function () {
                if(!this.patientRequest){
                    return $q(function(resolve, reject){
                        resolve(this.patientContext);
                    }.bind(this));
                }
            },

            searchForPatient: function (id) {
                return this.search({
                    identifier: id
                }).then(function (pgdResult) {
                    if (pgdResult.getTotal() > 0) { //patient found
                        var patient = pgdResult.getItems();
                        this.patientContext = patient[0];
                        return this.patientContext; //getItems should only return 1 or 0 items
                    }
                    //patient not found, create context
                    return null;
                }.bind(this))
            },

            createPatient: function (patientData) {
                var request = $q.defer();
                var that = this;

                localResourceDirectoryService.fetch().then(function(directory) {
                    var icn_identifier_system = directory["pgd-icn-identifier-system"];
                    
                    var patientContext = {
                        "resourceType": "Patient",
                        "identifier": [
                            {
                                "system": icn_identifier_system,
                                "type": {
                                    "coding": [
                                        {
                                            "code": "ICN"
                                        }
                                    ]
                                },
                                "value": patientData.icn
                            }
                        ],
                        "active": true,
                        "name": [
                            {
                                "use": "official",
                                "text": patientData.lastName + ", " + patientData.firstName,
                                "family": [
                                    patientData.lastName
                                ],
                                "given": [
                                    patientData.firstName
                                ]
                            }
                        ]
                    };

                    that.create(patientContext).then(function (result) {
                        request.resolve(result.status);
                    }, function (error) {
                        request.reject(error);
                    });
                });

                return request.promise;
            },
            
            setPatientContext: function(user){
                if(!this.request){
                    this.request = $q(function(resolve, reject){
                        this.searchForPatient(user.icn).then(function (retVal) {
                            if (retVal) {
                                resolve (true);
                            }
                            else {
                                this.createPatient(user).then(function(status){
                                    if(status == 201){
                                        resolve(true);
                                    }
                                });
                            }
                        }.bind(this));
                    }.bind(this))
                }

                return this.request;

            },
            //Workaround because the FHIR server doesn't allow querying immediately after creating a resource
            pgdfhirSleepForAccess: function (id) {
                return $q(function (resolve, reject) {
                    setTimeout(function () {
                        resolve(this.searchForPatient(id));
                    }.bind(this), 1000)
                }.bind(this));
            }

        });
    });
});
